package tests;

import java.util.TreeSet;

import model.AttractionPassChecker;
import model.Pass;
import model.attractioncounters.Attraction;
import model.passes.APass;
import model.passes.BPass;
import model.passes.CPass;

public class AttractionCounterTest {

	public static void main(String[] args) {
		
		AttractionPassChecker raptor = new Attraction("Raptor");
		AttractionPassChecker rollercoaster = new Attraction("RollerCoaster");
		TreeSet<String> set = new TreeSet<String>();
		set.add(raptor.getID());
		set.add(rollercoaster.getID());
		
		System.out.println("test A:");
		Pass pass = new APass();
		raptor.check(pass);
		raptor.check(pass);
		raptor.check(pass);
		System.out.println("\ntest C:");
		pass = new CPass();
		raptor.check(pass);
		raptor.check(pass);
		raptor.check(pass);
		raptor.check(pass);
		System.out.println("\ntest B:");
		pass = new BPass(set);
		raptor.check(pass);
		raptor.check(pass);
		System.out.println(pass.getEntriesLeftAt("Raptor"));
		raptor.check(pass);
		rollercoaster.check(pass);
	}
}
